<%@ Page Title="TBI Instruments - TBI Care Plan Instrument Questions / Answers" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="InstrumentCarePlanEntry.aspx.cs" Inherits="TBI_InstrumentCarePlanEntry" MaintainScrollPositionOnPostback="true" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Namespace="CustomValidators" Assembly="__code" TagPrefix="web" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />

    <style type="text/css">
        .breadcrumbInstrument {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }

        .detailTable {
            border: 0px;
            background-color: #FFFFFF;
        }

            .detailTable td {
                border: 0px;
                background-color: #FFFFFF;
            }

        .requiredField {
            font-weight: bold;
            color: #FF0000;
        }
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <asp:ScriptManager ID="ScriptManager1" AsyncPostBackTimeout="750" runat="server">
    </asp:ScriptManager>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
        <script type="text/javascript">
            var tmr = null;

            function getTimerReference() {
                if (tmr == null) {
                    tmr = $find("<%= InactiveTimer.ClientID %>");
            }

            return tmr;
        }

        function StopTimer() {
            // alert('stop');
            getTimerReference()._stopTimer();
        }

        function StartTimer() {
            //alert('start');
            getTimerReference()._startTimer();
        }

        function startRequest(sender, e) {
            StartTimer();
            //disable button during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            $('#<%= PanelQuestions.ClientID %>').hide();
        }
        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
        }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {

                //Disables 'Enter' Key from posting back on any input element ( textbox, radiolist, checkbox, etc )
                //also resets inactive timer
                $('input').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                    //if (e.keyCode == 13) { return false; }
                });

                //Disables 'Enter' Key from posting back when no input element is in focus, and the enter key is presssed
                //also resets inactive timer
                $('div').keydown(function (e) {
                    StopTimer();
                    StartTimer();
                    //if (e.keyCode == 13) { return false; }
                });

                //resets inactive timer on click of a radio element
                $('input[type=radio]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                //resets inactive timer on click of a checkbox element
                $('input[type=checkbox]').click(function (e) {
                    StopTimer();
                    StartTimer();
                });

                window.onbeforeunload = function () {
                    return;
                }

                //Show/hide textboxes associated with list selections 
                CheckBoxListQ2_Click();
                CheckBoxListQ3_Click();
                handleRepeater_detail('CheckBoxQ4', 'TextBoxQ4Detail')
                handleRepeater_detail('CheckBoxQ6', 'TextBoxQ6Detail')
                RadioButtonListQ7_Click();
                RadioButtonListQI7_1_Click();
                handleRepeater_detail('CheckBoxQ10', 'TextBoxQ10Detail')

            });
            // END $(document).ready(function()


            function btnSaveButtonChange_Click() {

            }

            function validateNoteType(sender, args) {

                var noteType = document.getElementById("<%=hiddenNoteType.ClientID%>").value;
        var newType = GetListIndexSelected("<%=RadioButtonListNoteType.ClientID%>");

        //Initial changed to something else
        if ((noteType == "0") && (newType != -1) && (newType != 0)) {
            args.IsValid = false;
            return;
        }

        //Non-initial changed to Initial
        if ((noteType != "0") && (noteType != "") && (newType == 0)) {
            args.IsValid = false;
            return;
        }
    }

    function handleList_Other(listName, textBoxName) {

        // Handle Detail text box associated with Other selection
        var list = document.getElementById(listName);
        var listItems = list.getElementsByTagName("input");
        var textBox = document.getElementById(textBoxName);

        if (listItems[listItems.length - 1].checked) {
            textBox.style.display = 'block';
            textBox.focus();
        }
        else {
            textBox.style.display = 'none';
        }

        return;
    }

    function CheckBoxListQ2_Click() {

        handleList_Other("<%=CheckBoxListQ2.ClientID%>", "<%=TextBoxQ2Detail.ClientID%>");
        return;
    }

    function validateQ2Detail(sender, args) {

        args.IsValid = validateDetail("<%=CheckBoxListQ2.ClientID%>", "<%=TextBoxQ2Detail.ClientID%>");
        return;

    }

    function CheckBoxListQ3_Click() {

        handleList_Other("<%=CheckBoxListQ3.ClientID%>", "<%=TextBoxQ3Detail.ClientID%>");
        return;
    }

    function validateQ3Detail(sender, args) {

        args.IsValid = validateDetail("<%=CheckBoxListQ3.ClientID%>", "<%=TextBoxQ3Detail.ClientID%>");
        return;

    }

    function validateDetail(listName, textBoxName) {

        // Determine whether Detail text is provided for Other list selection
        var list = document.getElementById(listName);
        var listItems = list.getElementsByTagName("input");
        var textBox = document.getElementById(textBoxName);

        if (listItems[listItems.length - 1].checked) {
            if (trim(textBox.value) == "")
                return false;
            else
                return true;
        }
        else {
            return true;
        }
    }

    function trim(string) {

        //Trim leading and trailing spaces
        return string.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

    }

    function handleRepeater_detail(checkBoxName, textBoxName) {

        //Show/hide text boxes associated with checkboxes in the repeater
        for (i = 0; i < document.forms[0].elements.length; i++) {

            elm = document.forms[0].elements[i]

            if ((elm.type == "checkbox") && (elm.id.indexOf(checkBoxName) >= 0)) {
                textBox = document.getElementById(elm.id.replace(checkBoxName, textBoxName));
                if (elm.checked == true) {
                    textBox.style.display = 'block';
                    if (document.activeElement.id == elm.id) {
                        textBox.focus();
                    }
                }
                else {
                    textBox.style.display = 'none';
                }
            }
        }

        return;

    }

    function validateQ4Selection(sender, args) {

        args.IsValid = validateRepeater_selection("CheckBoxQ4", "TextBoxQ4Detail");

        var questionLabel = document.getElementById("<%=Q4Label.ClientID%>");
        if (questionLabel != null) {
            if (questionLabel.attributes["nameControlToValidate"] != null) {
                sender.controltovalidate = questionLabel.attributes["nameControlToValidate"].value;
            }
        }

        return;

    }

    function validateQ6Selection(sender, args) {

        args.IsValid = validateRepeater_selection("CheckBoxQ6", "TextBoxQ6Detail");

        var questionLabel = document.getElementById("<%=Q6Label.ClientID%>");
        if (questionLabel != null) {
            if (questionLabel.attributes["nameControlToValidate"] != null) {
                sender.controltovalidate = questionLabel.attributes["nameControlToValidate"].value;
            }
        }

        return;

    }

    function validateQ10Selection(sender, args) {

        args.IsValid = validateRepeater_selection("CheckBoxQ10", "TextBoxQ10Detail");

        var questionLabel = document.getElementById("<%=Q10Label.ClientID%>");
        if (questionLabel != null) {
            if (questionLabel.attributes["nameControlToValidate"] != null) {
                sender.controltovalidate = questionLabel.attributes["nameControlToValidate"].value;
            }
        }

        return;

    }

    function validateRepeater_selection(checkBoxName, textBoxName) {

        //Determine whether at least one checkbox in the repeater is checked
        var ret = -1;

        for (i = 0; i < document.forms[0].elements.length; i++) {

            elm = document.forms[0].elements[i]

            if ((elm.type == "checkbox") && (elm.id.indexOf(checkBoxName) >= 0)) {
                if (elm.checked == true) {
                    ret = i;
                    break;
                }
            }
        }

        if (ret == -1) {
            return false;
        }
        else {
            return true;
        }

    }

    function validateRepeaterDetail(sender, args) {

        var chkBox = null;
        var txtBox = null;
        if (sender.attributes["chkId"] != null) {
            chkBox = document.getElementById(sender.attributes["chkId"].value);
        }
        if (sender.attributes["txtId"] != null) {
            txtBox = document.getElementById(sender.attributes["txtId"].value);
        }

        if (sender.attributes["flagOther"] != null) {
            if ((sender.attributes["flagOther"].value == "true") && (chkBox.checked == true)) {
                if (trim(txtBox.value) == "") {
                    sender.controltovalidate = sender.attributes["txtId"].value;
                    args.IsValid = false;
                }
            }
        }
        return;

    }

    function validateQ7Detail(sender, args) {

        var currIndex = GetListIndexSelected("<%=RadioButtonListQ7.ClientID%>");
        var otherIndex = GetLastElementIndex("<%=RadioButtonListQ7.ClientID%>");

        if (currIndex == otherIndex) {
            if (trim($('#<%= TextBoxQ7Detail.ClientID %>').val()) == "") {
                args.IsValid = false;
                return;
            }
            else {
                args.IsValid = true;
                return;
            }

        }

    }

    function RadioButtonListQ7_Click() {
        handleList_Other("<%=RadioButtonListQ7.ClientID%>", "<%=TextBoxQ7Detail.ClientID%>");
        return;
    }

    function RadioButtonListQI7_1_Click() {

        //Show/hide dependent question
        var itemSelected = GetListIndexSelected("<%=RadioButtonListQI7_1.ClientID%>");
        var fieldsetQI7_2 = document.getElementById("QI7_2Fieldset");

        if (itemSelected == 0) //Yes
        {
            fieldsetQI7_2.style.display = "block";
        }
        else {
            fieldsetQI7_2.style.display = "none";
        }

        return;
    }


    function validateQI7_2(sender, args) {

        //Require selection in QI7_2 if YES is selected in QI7_1
        var responseQI7_1 = GetListIndexSelected("<%=RadioButtonListQI7_1.ClientID%>");

        if (responseQI7_1 == 0) //Yes
        {
            var responseQI7_2 = GetListIndexSelected("<%=RadioButtonListQI7_2.ClientID%>");
            if (responseQI7_2 == -1)
                args.IsValid = false;
        }

        return;
    }

    function GetListIndexSelected(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        for (var i = 0; i < radio.length; i++) {
            if (radio[i].checked) {
                ret = i;
                break;
            }
        }

        return ret;

    }

    function GetLastElementIndex(listName) {
        var rbList = document.getElementById(listName);
        var radio = rbList.getElementsByTagName("input");
        var ret = -1;

        ret = radio.length - 1;

        return ret;
    }

    function LimitLength(txtBox) {

        var maxLength = 2000;

        if ((txtBox.value).length > maxLength) {
            txtBox.value = (txtBox.value).substring(0, maxLength);;
            alert("Your entry has been trancated to the maximum allowed length of " + maxLength + " characters.");
        }
    }

        </script>
    </telerik:RadCodeBlock>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > REHABILITATION AND REINTEGRATION PLAN"></asp:Label>
        </div>
    </telerik:RadCodeBlock>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock4">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>

                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave"
                    runat="server"
                    TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList"
                    ShowSummary="false"
                    ShowMessageBox="true"
                    ValidationGroup="OnSave" />


                <br />
                <asp:Panel ID="PanelObjectContent" runat="server" CssClass="content">
                    <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                        <table cellpadding="5" cellspacing="5">
                            <tr>
                                <td>&nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel"></asp:Label></td>
                                <td>
                                    <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                    &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel"></asp:Label></td>
                                <td>
                                    <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                    &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel"></asp:Label></td>
                            </tr>
                        </table>
                    </asp:Panel>

                     <asp:HiddenField ID="hiddenNoteType" runat="server"   />

                    <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="CAREPLAN" />

                    <!-- Instruction Area -->
                    <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                        <br />
                        <div style="padding: 5px; width: 900px;">
                        </div>
                    </asp:Panel>
                    <!-- End Instruction Area -->


                    <asp:Panel ID="PanelSurveyHeader" Width="100%" CssClass="mainContent" runat="server">
                        <table cellpadding="5" cellspacing="5">
                            <tr>
                                <td>
                                    <asp:Label ID="LabelInstrumentDesc" runat="server">
                            This note documents the interdisciplinary team assessment, goals, and plan.  Team membership is comprised of the Veteran or Active Duty Service member, family, and clinical providers as indicated in the body of the note below.
                                    </asp:Label>
                                    <br />
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <table cellpadding="5" cellspacing="5" width="100%">
                                        <tr>
                                            <td width="10%">
                                                <asp:Label ID="NoteTypeLabel" runat="server" AssociatedControlID="RadioButtonListNoteType">
                                        &nbsp;Note Type:
                                                </asp:Label>
                                            </td>
                                            <td>
                                                <asp:RadioButtonList ID="RadioButtonListNoteType" runat="server"
                                                    RepeatDirection="Vertical"
                                                    DataSourceID="ObjectDataSourceNoteType"
                                                    DataTextField="CHOICE_TEXT"
                                                    DataValueField="STD_QUESTION_CHOICE_ID" />
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorNoteType"
                                                    ControlToValidate="RadioButtonListNoteType"
                                                    Display="Dynamic"
                                                    runat="server"
                                                    EnableClientScript="true"
                                                    ErrorMessage="Note Type entry is required."
                                                    SetFocusOnError="true"
                                                    ValidationGroup="OnSave" />
                                                <asp:CustomValidator ID="CustomValidatorNoteType"
                                                    ControlToValidate="RadioButtonListNoteType"
                                                    runat="server"
                                                    Display="Dynamic"
                                                    ErrorMessage="Please correct Note Type selection."
                                                    ClientValidationFunction="validateNoteType"
                                                    ValidationGroup="OnSave"
                                                    EnableClientScript="true"
                                                    ValidateEmptyText="true"
                                                    SetFocusOnError="true" />
                                            </td>
                                        </tr>
                                    </table>
                                    <asp:ObjectDataSource ID="ObjectDataSourceNoteType" runat="server"
                                        SelectMethod="GetQuestionChoices"
                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenFieldQ_1" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="HiddenFieldQ_1" runat="server" Visible="false" Value="-1" />
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>

                    <asp:Panel ID="PanelQuestions" Width="100%" runat="server">
                        <table cellpadding="5" cellspacing="5" width="100%">
                            <tr id="TrQ1">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q1Label" AssociatedControlID="TextBoxQ1" runat="server" CssClass="firstLevelQuestion">
                                        1. History of present illness/interim history since last team note:
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ1" runat="server" Width="98%"
                                                        TextMode="MultiLine" Rows="5"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1"
                                                        ControlToValidate="TextBoxQ1"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Response to Question 1 is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ2">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q2Label" AssociatedControlID="CheckBoxListQ2" runat="server" CssClass="firstLevelQuestion">
                                        2. Current problems: (Patient has identified needing help in addressing the symptoms selected below as they are frequently present and disrupt activities.)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:CheckBoxList ID="CheckBoxListQ2" runat="server"
                                                        DataSourceID="ObjectDataSourceQ2"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        onclick="CheckBoxListQ2_Click()" />
                                                    <asp:TextBox ID="TextBoxQ2Detail" runat="server"
                                                        Width="98%"
                                                        TextMode="MultiLine" Rows="1"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <web:RequiredFieldValidatorForCheckBoxLists ID="RequiredFieldValidatorForCheckBoxListsQ2"
                                                        ControlToValidate="CheckBoxListQ2"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Please select at least one option in Question 2."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" />
                                                    <asp:CustomValidator ID="CustomValidatorQ2Detail"
                                                        ControlToValidate="TextBoxQ2Detail"
                                                        runat="server"
                                                        Display="Dynamic"
                                                        EnableClientScript="true"
                                                        SetFocusOnError="true"
                                                        ValidateEmptyText="true"
                                                        ErrorMessage="Please enter a comment for Other selection in Question 2."
                                                        ClientValidationFunction="validateQ2Detail"
                                                        ValidationGroup="OnSave" />
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:Label ID="Q2CommentLabel" AssociatedControlID="TextBoxQ2Comment" runat="server" CssClass="firstLevelAnswer">
                                        Additional Comments: 
                                                    </asp:Label>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ2Comment" runat="server" Width="98%"
                                                        TextMode="MultiLine" Rows="5" CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2Comment"
                                                        ControlToValidate="TextBoxQ2Comment"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Additional Comments in Question 2 are required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ3">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q3Label" AssociatedControlID="CheckBoxListQ3" runat="server" CssClass="firstLevelQuestion">
                                        3. Interdisciplinary Treatment (IDT) evaluations: (Check all that apply)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:CheckBoxList ID="CheckBoxListQ3" runat="server"
                                                        DataSourceID="ObjectDataSourceQ3"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        onclick="CheckBoxListQ3_Click()" />
                                                    <asp:TextBox ID="TextBoxQ3Detail" runat="server"
                                                        Width="98%"
                                                        TextMode="MultiLine" Rows="1"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <web:RequiredFieldValidatorForCheckBoxLists ID="RequiredFieldValidatorForCheckBoxListsQ3"
                                                        ControlToValidate="CheckBoxListQ3"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Please select at least one option in Question 3."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </web:RequiredFieldValidatorForCheckBoxLists>
                                                    <asp:CustomValidator ID="CustomValidatorQ3Detail"
                                                        ControlToValidate="TextBoxQ3Detail"
                                                        runat="server"
                                                        Display="Dynamic"
                                                        ErrorMessage="Please enter a comment for Other selection in Question 3."
                                                        ClientValidationFunction="validateQ3Detail"
                                                        ValidationGroup="OnSave"
                                                        EnableClientScript="true"
                                                        ValidateEmptyText="true"
                                                        SetFocusOnError="true" />
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:Label ID="Q3CommentLabel" AssociatedControlID="TextBoxQ3Comment" runat="server" CssClass="firstLevelAnswer">
                                        Summary of evaluations (including family education and family support needs): 
                                                    </asp:Label>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ3Comment" runat="server" Width="98%"
                                                        TextMode="MultiLine" Rows="5"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3Comment"
                                                        ControlToValidate="TextBoxQ3Comment"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Additional Comments in Question 3 are required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ4">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q4Label" AssociatedControlID="RepeaterQ4" runat="server" CssClass="firstLevelQuestion">
                                        4. Interdisciplinary Treatment Team Goals
                                                    </asp:Label>

                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:Repeater
                                                        ID="RepeaterQ4"
                                                        DataSourceID="ObjectDataSourceQ4"
                                                        runat="server">
                                                        <ItemTemplate>
                                                            <asp:Label ID="LabelQ4ChoiceID" runat="server" Visible="false" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_QUESTION_CHOICE_ID"))) %>' />
                                                            <asp:CheckBox ID="CheckBoxQ4" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT"))) %>' onclick="handleRepeater_detail('CheckBoxQ4', 'TextBoxQ4Detail')" />
                                                            <br />
                                                            <asp:TextBox ID="TextBoxQ4Detail" runat="server" Width="98%" TextMode="MultiLine" Rows="1" CssClass="firstLevelAnswer" onblur="LimitLength(this)" />
                                                            <asp:CustomValidator ID="CustomValidatorRepeaterQ4_Detail"
                                                                ControlToValidate=""
                                                                runat="server"
                                                                Display="Dynamic"
                                                                ErrorMessage="Please enter a comment for Other selection in Question 4."
                                                                ClientValidationFunction="validateRepeaterDetail"
                                                                EnableClientScript="true"
                                                                ValidateEmptyText="true"
                                                                SetFocusOnError="true"
                                                                ValidationGroup="OnSave" />
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                    <asp:CustomValidator ID="CustomValidatorRepeaterQ4_Selection"
                                                        ControlToValidate=""
                                                        runat="server"
                                                        Display="Dynamic"
                                                        ErrorMessage="Please select at least one option in Question 4."
                                                        ClientValidationFunction="validateQ4Selection"
                                                        EnableClientScript="true"
                                                        ValidateEmptyText="true"
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" />
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ5">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q5Label" AssociatedControlID="TextBoxQ5" runat="server" CssClass="firstLevelQuestion">
                                        5. Rehabilitation and reintegration plan: (Types of services, frequency/duration of treatment, planned follow up, etc.)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ5" runat="server" Width="98%"
                                                        TextMode="MultiLine" Rows="5"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5"
                                                        ControlToValidate="TextBoxQ5"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Response to Question 5 is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ6">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q6Label" AssociatedControlID="RepeaterQ6" runat="server" CssClass="firstLevelQuestion">
                                        6. Consults requested and/or follow-up on consults
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:Repeater
                                                        ID="RepeaterQ6"
                                                        DataSourceID="ObjectDataSourceQ6"
                                                        runat="server">
                                                        <ItemTemplate>
                                                            <asp:Label ID="LabelQ6ChoiceID" runat="server" Visible="false" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_QUESTION_CHOICE_ID"))) %>' />
                                                            <asp:CheckBox ID="CheckBoxQ6" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT"))) %>' onclick="handleRepeater_detail('CheckBoxQ6', 'TextBoxQ6Detail')" />
                                                            <br />
                                                            <asp:TextBox ID="TextBoxQ6Detail" runat="server" Width="98%" TextMode="MultiLine" Rows="1" CssClass="firstLevelAnswer" onblur="LimitLength(this)" />
                                                            <asp:CustomValidator ID="CustomValidatorRepeaterQ6_Detail"
                                                                ControlToValidate=""
                                                                runat="server"
                                                                Display="Dynamic"
                                                                ErrorMessage="Please enter a comment for Other selection in Question 6."
                                                                ClientValidationFunction="validateRepeaterDetail"
                                                                EnableClientScript="true"
                                                                ValidateEmptyText="true"
                                                                SetFocusOnError="true"
                                                                ValidationGroup="OnSave" />
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                    <asp:CustomValidator ID="CustomValidatorRepeaterQ6_Selection"
                                                        ControlToValidate=""
                                                        runat="server"
                                                        Display="Dynamic"
                                                        ErrorMessage="Please select at least one option in Question 6."
                                                        ClientValidationFunction="validateQ6Selection"
                                                        EnableClientScript="true"
                                                        ValidateEmptyText="true"
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" />
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ7">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q7Label" AssociatedControlID="RadioButtonListQ7" runat="server" CssClass="firstLevelQuestion">
                                        7. Proposed timeframe for IDT follow up conference
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:RadioButtonList ID="RadioButtonListQ7" runat="server" RepeatDirection="Vertical"
                                                        DataSourceID="ObjectDataSourceQ7"
                                                        DataTextField="CHOICE_TEXT"
                                                        DataValueField="STD_QUESTION_CHOICE_ID"
                                                        onclick="RadioButtonListQ7_Click()" />
                                                    <asp:TextBox ID="TextBoxQ7Detail" runat="server"
                                                        Width="30%"
                                                        TextMode="MultiLine" Rows="1"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                    <br />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7"
                                                        ControlToValidate="RadioButtonListQ7"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Response to Question 7 is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                    <asp:CustomValidator ID="CustomValidatorQ7Detail"
                                                        ControlToValidate="TextBoxQ7Detail"
                                                        runat="server"
                                                        Display="Dynamic"
                                                        ErrorMessage="Please enter a comment for Other selection in Question 7."
                                                        ClientValidationFunction="validateQ7Detail"
                                                        EnableClientScript="true"
                                                        ValidateEmptyText="true"
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave" />
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <table cellpadding="5" cellspacing="5" width="100%">
                                                        <tr>
                                                            <td width="50%">
                                                                <fieldset class="secondLevelAnswer">
                                                                    <table width="100%">
                                                                        <tr class="subquestionBackgroundColor">
                                                                            <td>
                                                                                <asp:Label ID="QI7_1Label" AssociatedControlID="RadioButtonListQI7_1" runat="server" CssClass="firstLevelQuestion">
                                                                Plan of care communicated
                                                                                </asp:Label>
                                                                                <br />
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>
                                                                                <asp:RadioButtonList ID="RadioButtonListQI7_1" runat="server"
                                                                                    RepeatDirection="Vertical"
                                                                                    DataSourceID="ObjectDataSourceQI7_1"
                                                                                    DataTextField="CHOICE_TEXT"
                                                                                    DataValueField="STD_QUESTION_CHOICE_ID"
                                                                                    onclick="RadioButtonListQI7_1_Click()" />
                                                                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQI7_1"
                                                                                    ControlToValidate="RadioButtonListQI7_1"
                                                                                    Display="Dynamic"
                                                                                    runat="server"
                                                                                    EnableClientScript="true"
                                                                                    ErrorMessage="Please indicate whether plan of care in Question 7 has been communicated."
                                                                                    SetFocusOnError="true"
                                                                                    ValidationGroup="OnSave">
                                                                                </asp:RequiredFieldValidator>
                                                                                <asp:ObjectDataSource ID="ObjectDataSourceQI7_1" runat="server"
                                                                                    SelectMethod="GetQuestionChoices"
                                                                                    TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                    <SelectParameters>
                                                                                        <asp:ControlParameter ControlID="HiddenQI7_1" Direction="Input" Name="questionNumber" Type="String" />
                                                                                    </SelectParameters>
                                                                                </asp:ObjectDataSource>
                                                                                <asp:HiddenField ID="HiddenQI7_1" runat="server" Visible="false" Value="I7-1" />
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </fieldset>
                                                            </td>
                                                            <td>
                                                                <fieldset id="QI7_2Fieldset" class="secondLevelAnswer">
                                                                    <table width="100%">
                                                                        <tr class="subquestionBackgroundColor">
                                                                            <td>
                                                                                <asp:Label ID="QI7_2Label" AssociatedControlID="RadioButtonListQI7_2" runat="server" CssClass="firstLevelQuestion">
                                                                Mode of communication
                                                                                </asp:Label>
                                                                                <br />
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td>
                                                                                <asp:RadioButtonList ID="RadioButtonListQI7_2" runat="server"
                                                                                    RepeatDirection="Vertical"
                                                                                    DataSourceID="ObjectDataSourceQI7_2"
                                                                                    DataTextField="CHOICE_TEXT"
                                                                                    DataValueField="STD_QUESTION_CHOICE_ID" />
                                                                                <asp:CustomValidator ID="CustomValidatorQI7_2"
                                                                                    ControlToValidate="RadioButtonListQI7_2"
                                                                                    runat="server"
                                                                                    Display="Dynamic"
                                                                                    ErrorMessage="Please indicate mode of communication in Question 7."
                                                                                    ClientValidationFunction="validateQI7_2"
                                                                                    EnableClientScript="true"
                                                                                    ValidateEmptyText="true"
                                                                                    SetFocusOnError="true"
                                                                                    ValidationGroup="OnSave" />
                                                                                <asp:ObjectDataSource ID="ObjectDataSourceQI7_2" runat="server"
                                                                                    SelectMethod="GetQuestionChoices"
                                                                                    TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                                                    <SelectParameters>
                                                                                        <asp:ControlParameter ControlID="HiddenQI7_2" Direction="Input" Name="questionNumber" Type="String" />
                                                                                    </SelectParameters>
                                                                                </asp:ObjectDataSource>
                                                                                <asp:HiddenField ID="HiddenQI7_2" runat="server" Visible="false" Value="I7-2" />
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </fieldset>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ8">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q8Label" AssociatedControlID="TextBoxQ8" runat="server" CssClass="firstLevelQuestion">
                                        8. Physician responsible for managing the treatment plan: (Name and telephone number)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ8" runat="server" Width="98%" TextMode="MultiLine" Rows="1" CssClass="firstLevelAnswer" onblur="LimitLength(this)" />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8"
                                                        ControlToValidate="TextBoxQ8"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Response to Question 8 is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ9">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q9Label" AssociatedControlID="TextBoxQ9" runat="server" CssClass="firstLevelQuestion">
                                        9. Polytrauma-TBI Case Manager responsible for monitoring implementation: (Name and telephone number)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ9" runat="server" Width="98%" TextMode="MultiLine" Rows="1" CssClass="firstLevelAnswer" onblur="LimitLength(this)" />
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9"
                                                        ControlToValidate="TextBoxQ9"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Response to Question 9 is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ10">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q10Label" AssociatedControlID="RepeaterQ10" runat="server" CssClass="firstLevelQuestion">
                                        10. Other case management support (Optional): (Name and telephone number)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <asp:Repeater
                                                        ID="RepeaterQ10"
                                                        DataSourceID="ObjectDataSourceQ10"
                                                        runat="server">
                                                        <ItemTemplate>
                                                            <asp:Label ID="LabelQ10ChoiceID" runat="server" Visible="false" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_QUESTION_CHOICE_ID"))) %>' />
                                                            <asp:CheckBox ID="CheckBoxQ10" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT"))) %>' onclick="handleRepeater_detail('CheckBoxQ10', 'TextBoxQ10Detail')" />
                                                            <br />
                                                            <asp:TextBox ID="TextBoxQ10Detail" runat="server" Width="98%" TextMode="MultiLine" Rows="1" CssClass="firstLevelAnswer" onblur="LimitLength(this)" />
                                                            <asp:CustomValidator ID="CustomValidatorRepeaterQ10_Detail"
                                                                ControlToValidate=""
                                                                runat="server"
                                                                Display="Dynamic"
                                                                ErrorMessage="Please enter a comment for Other selection in Question 10."
                                                                ClientValidationFunction="validateRepeaterDetail"
                                                                EnableClientScript="true"
                                                                ValidateEmptyText="true"
                                                                SetFocusOnError="true"
                                                                ValidationGroup="OnSave" />
                                                        </ItemTemplate>
                                                    </asp:Repeater>
                                                    <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server"
                                                        SelectMethod="GetQuestionChoices"
                                                        TypeName="VeteransAffairs.Registries.QuestionChoiceRetriever">
                                                        <SelectParameters>
                                                            <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                                        </SelectParameters>
                                                    </asp:ObjectDataSource>
                                                    <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ11">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q11Label" AssociatedControlID="TextBoxQ11" runat="server" CssClass="firstLevelQuestion">
                                        11. Date care plan will be reviewed
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ11" runat="server" Width="80px" MaxLength="10"
                                                        CssClass="firstLevelAnswer">
                                                    </asp:TextBox>
                                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11"
                                                        ControlToValidate="TextBoxQ11"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Response to Question 11 is required."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:RequiredFieldValidator>
                                                    <asp:CompareValidator ID="CompareValidatorQ11_1"
                                                        ControlToValidate="TextBoxQ11"
                                                        Display="Dynamic"
                                                        runat="server"
                                                        Type="Date"
                                                        Operator="GreaterThanEqual"
                                                        EnableClientScript="true"
                                                        ErrorMessage="Please enter a valid date (MM/DD/YYYY) in Question 11. It must be equal or greater than the current date."
                                                        SetFocusOnError="true"
                                                        ValidationGroup="OnSave">
                                                    </asp:CompareValidator>
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                            <tr id="TrQ12">
                                <td>
                                    <fieldset>
                                        <table width="100%">
                                            <tr class="questionBackgroundColor">
                                                <td>
                                                    <asp:Label ID="Q12Label" AssociatedControlID="TextBoxQ12" runat="server" CssClass="firstLevelQuestion">
                                        12. Additional Information (Optional)
                                                    </asp:Label>
                                                    <br />
                                                    <br />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <br />
                                                    <asp:TextBox ID="TextBoxQ12" runat="server" Width="98%"
                                                        TextMode="MultiLine" Rows="5"
                                                        CssClass="firstLevelAnswer"
                                                        onblur="LimitLength(this)" />
                                                </td>
                                            </tr>
                                        </table>
                                    </fieldset>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                </asp:Panel>

                <br />
                <br />

                <asp:Button ID="btnSaveSurveyDraft" runat="server"
                    UseSubmitBehavior="false"
                    Text="Save Draft"
                    Width="130px"
                    OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" />

                <asp:Button ID="btnSubmitSurvey" runat="server"
                    UseSubmitBehavior="false"
                    Text="Save and Prepare Note"
                    Width="180px"
                    OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" />

                <asp:Button ID="btnCancelSurvey" runat="server"
                    TabIndex="39"
                    UseSubmitBehavior="false"
                    Text="Cancel"
                    Width="130px"
                    OnClick="btnCancel_Click" />
                <br />
                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />

                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 320px; color: #FFFFFF; padding: 5px;">
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Processing...Please wait.
                            </div>
                        </div>

                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <br />
                <asp:Label ID="LabelSaveInstructions" runat="server" SkinID="DataLabel">
                    If you are unable to finish at this time, or if you just want to save while entering, click Save Draft.<br /><br />

                    If you are finished with entry, and ready to save and format the note (you will get another chance to review prior to submit),<br /> 
                    click Save and Prepare Note.<br /><br />     
                      
                    If you want to return to CPRS press the Cancel Button. Do not use Internet browser back arrow.               
                </asp:Label>

            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>

